package gov.va.med.mhv.integration.phr.message;

import gov.va.med.mhv.integration.phr.enumeration.ExtractType;
import gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageFormatType;
import gov.va.med.mhv.integration.phr.stage.enumeration.StageRoutingStatusType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * User: Rob Murtha
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface MessageSelector {
    String messageName();
    String extractType() default ExtractType.REFRESH;
    String messageFormat() default StageMessageFormatType.SQL;
    String routingStatus() default StageRoutingStatusType.NEW;
}
